/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: ParseException.java,v 1.1.1.1 2001/01/05 05:11:18 sese0235 Exp $
 */

package de.kxml.io;

import java.io.*;

/**
 * a possibly chained exception, indicatin a line and column number.
 * FIXME: does adding a file name make sense ??
 */
public class ParseException extends IOException {
    protected int       lineNumber = -1;
    protected int       columnNumber = -1;
    protected Exception chained;

    /**
     * Constructor declaration
     *
     *
     * @param e
     *
     * @see
     */
    public ParseException(Exception e) {
	chained = e;
    }

    /**
     * Constructor declaration
     *
     *
     * @param e
     * @param desc
     *
     * @see
     */
    public ParseException(Exception e, String desc) {
	super(desc);

	chained = e;
    }

    /**
     * Constructor declaration
     *
     *
     * @param msg
     * @param lineNumber
     * @param columnNumber
     *
     * @see
     */
    public ParseException(String msg, int lineNumber, int columnNumber) {
	super(msg + " @" + lineNumber + ":" + columnNumber);

	this.lineNumber = lineNumber;
	this.columnNumber = columnNumber;
    }

    /**
     * Constructor declaration
     *
     *
     * @param e
     * @param lineNumber
     * @param columnNumber
     *
     * @see
     */
    public ParseException(Exception e, int lineNumber, int columnNumber) {
	super("chained exception @" + lineNumber + ":" + columnNumber);

	chained = e;
	this.lineNumber = lineNumber;
	this.columnNumber = columnNumber;
    }

    /**
     * Constructor declaration
     *
     *
     * @param e
     * @param reader
     *
     * @see
     */
    public ParseException(Exception e, LookAheadReader reader) {
	this(e, reader.getLineNumber(), reader.getColumnNumber());
    }

    /**
     * Constructor declaration
     *
     *
     * @param desc
     * @param reader
     *
     * @see
     */
    public ParseException(String desc, LookAheadReader reader) {
	this(desc, reader.getLineNumber(), reader.getColumnNumber());
    }

    /*
     * Removed since super is not available in MIDP :(
     * prints the own
     * stack trace followed by the stack trace of the original
     * exception to the given PrintStream
     * public void printStackTrace (PrintStream p) {
     * super.printStackTrace (p);
     * if (chained != null)
     * chained.printStackTrace (p);
     * }
     * prints the own stack trace followed by the stack trace of the
     * original exception to the given PrintWriter
     * public void printStackTrace (PrintWriter p) {
     * super.printStackTrace (p);
     * if (chained != null)
     * chained.printStackTrace (p);
     * }
     */

    /**
     * prints the own stack trace followed by the stack trace of the
     * original exception.
     */
    public void printStackTrace() {

	// super.printStackTrace ();
	// if (chained != null)
	// chained.printStackTrace ();
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public int getLineNumber() {
	return lineNumber;
    } 

}

